function descriptor()

  return { title = "Scenerixx Bridge - Mark movie as favorite",
    version = "0.2",
    author = "ScenerixxDev",
    url = "www.scenerixx.com",
	shortdesc = "Scenerixx Bridge - Mark movie as favorite",
	description = "This plugin is a bridge into your local Scenerixx installation",
	capabilities = {"input-listener", "meta-listener", "playing-listener"},
  }
end


function activate()
        vlc.msg.dbg("activate- mark movie as favorite")
		markMovieAsFavorite()
  return true
end

function markMovieAsFavorite()
    vlc.msg.dbg("mark movie as favorite: "..getCurrentFile())
    local res = get("http://localhost:7679/api/v1/markMovieAsFavorite?filename="..getCurrentFile())
    if(string.find(res, "marked as favorite")) then
        vlc.osd.message("Marked movie as favorite")
    else
	vlc.osd.message("An error occured - Could not find movie")
    end
end

function get(url)
  vlc.msg.dbg("passed url: "..url)
  local u = vlc.net.url_parse(url)
  vlc.msg.dbg("passed options: "..u["option"])
  local host, port, path, params = u["host"], u["port"], u["path"], u["option"]
  local header = {
    "GET "..path.."?"..params.." HTTP/1.1",
    "Host: "..host,
    "",
    ""
  }
  local request = table.concat(header, "\r\n")
  vlc.msg.dbg("request: "..request)
  return http_req(host, port, request)
end

function http_req(host, port, request)
  vlc.msg.dbg("host "..host)
  vlc.msg.dbg("port "..port)
  vlc.msg.dbg("request "..request)
  local fd = vlc.net.connect_tcp(host, port)
  vlc.msg.dbg("fd "..fd)
  if not fd then return false end

  if fd==3 then 
	vlc.osd.message("Cannot connect to server - is ScenerixxHub running?")
	return false 
  end
  
  local pollfds = {}

  pollfds[fd] = vlc.net.POLLIN
  vlc.net.send(fd, request)
  vlc.net.poll(pollfds)

  vlc.msg.dbg("start receivingX")
  local chunk = vlc.net.recv(fd, 2048)
  vlc.msg.dbg("chunk: "..chunk)
  vlc.msg.dbg("close now ")
  vlc.net.close(fd)
  return chunk
end

function getCurrentFile()
		local item = vlc.input.item()
		local uri = item:uri()
		vlc.msg.dbg("current uri: "..uri)
		uri = string.gsub(uri, '&', '%%26')
		uri = string.gsub(uri, '^file:///', '')
		uri = string.gsub(uri, '\\', '\\\\')
		vlc.msg.dbg("current file "..uri)
		return uri
end

function close()
  vlc.msg.dbg("[Scenerixx Bridge] Close")
end

function deactivate()
  local duration = getTimePassed()
  duration = duration / 1000 / 1000
  vlc.msg.dbg("time passed on deactivation: "..duration)
  activate()
end

function getTimePassed()
    if (vlc.object.input() == nil) then
	return -1
    else
        return vlc.var.get(vlc.object.input(), "time")
    end
end

function input_changed()
   -- related to capabilities={"input-listener"} in descriptor()
   -- triggered by Start/Stop media input event
   vlc.msg.dbg("input changed " .. vlc.playlist.status())
end

function playing_changed()
   -- related to capabilities={"playing-listener"} in descriptor()
   -- triggered by Pause/Play madia input event
	vlc.msg.dbg("playing changed " .. vlc.playlist.status())
end

function meta_changed()
	vlc.msg.dbg("meta changed " .. vlc.playlist.status())
end
